﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;


namespace Demo
{
   class adt8940a1
    {
       [DllImport("8940a1.dll")]
public static extern Int16  adt8940a1_initial();
/************************************************
(1) Return >0 means amount of installed adt8940 cards; in case the returning value is 3, the available card numbers shall be 0, 1, and 2;
(2) Return =0 means no installation of adt8940 card;
(3) Return <0 means no installation of service if the value is -1 or PCI bus failure is the value is -2.
************************************************/
       [DllImport("8940a1.dll")]
public static extern Int16  get_lib_version(Int16 cardno);
/* Get current library version
Here returns are combination of hardware and library version number.
************************************************/
       [DllImport("8940a1.dll")]
public static extern float get_hardware_ver(Int16 cardno);
/* Get current hardware version
Here returns are combination of hardware and hardware version number.
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_pulse_mode(Int16 cardno,Int16 axis,Int16 value,Int16 logic,Int16 dir_logic);
/* Set outputted pulse mode
cardno	    Card number
axis		Axis number (1-4)
value       0：Pulse + Pulse method	    1：Pulse + direction method
logic		0：	Positive logic pulse	1：Negative logic pulse
dir_logic	0： Positive logic direction input signal 	1：Negative logic direction input signal
Return	    0：Correct					1： Wrong
Default mode: Pulse + direction, with positive logic pulse and positive logic direction input signal
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_limit_mode(Int16 cardno,Int16 axis,Int16 v1,Int16 v2,Int16 logic);
/*Set mode of nLMT signal input along positive/ negative direction
cardno	Card number
axis	Axis number (1-4)
v1		0: positive limit effective	1: positive limit ineffective
v2		0: negative limit effective 1: negative limit ineffective
logic	0: low level effective		1: high level ineffective
Return	0：Correct					1： Wrong
Default mode: Apply positive and negative limits with low level
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_stop0_mode(Int16 cardno,Int16 axis,Int16 v,Int16 logic);
/*Set mode of stop0 input signal
cardno	Card number
axis	Axis number (1-4)
v		0: ineffective		    1: effective
logic	0: low level effective	1: high level effective
Return	0: Correct				1: Wrong
Default mode: ineffective
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_stop1_mode(Int16 cardno,Int16 axis,Int16 v,Int16 logic);
/*Set mode of stop1 input signal
cardno	Card number
axis	Axis number (1-4)
v		0: ineffective		    1: effective
logic	0: low level effective	1: high level effective
Return	0: Correct				1: Wrong
Default mode: ineffective
*/

//----------------------------------------------------//
//                CATEGORY OF MOTION STATUS CHECK                      //
//----------------------------------------------------//
       [DllImport("8940a1.dll")]
public static extern Int16  get_status(Int16 cardno,Int16 axis,out Int16  v);
/*Get status of single-axis drive
cardno	Card number
axis	Axis number (1-4)
value	Indicator of drive status
0：Drive completed
Non-0: Drive in process
Return	0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  get_inp_status(Int16 cardno,out Int16  v);
/*Get status of Interpolation
cardno	Card number
value   Indicator of i Interpolation:
0: Interpolation completed	
1: Interpolation in process
Return	0: Correct				1: Wrong
*/


//----------------------------------------------------//
//               CATEGORY OF MOTION  PARAMETER SETTING                     //
//----------------------------------------------------//
       [DllImport("8940a1.dll")]
public static extern Int16  set_acc(Int16 cardno, Int16 axis,Int32   add);
/*Set acceleration
cardno	Card number
axis	Axis number 
add     acceleration(0-32000) 
Return 	0: Correct				1: Wrong  
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_startv(Int16 cardno, Int16 axis,Int32   speed);
/*Set starting speed
cardno	Card number
axis	Axis number
value	Speed(0-2M)
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_speed(Int16 cardno, Int16 axis,Int32   speed);
/*Set drive speed
cardno	Card number
axis	Axis number
value	Speed(0-2M)
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_command_pos(Int16 cardno, Int16 axis,Int32   pos);
/*set values for the logical position counter
cardno	Card number
axis	Axis number
value	Range (-2147483648~+2147483647)
Return	0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_actual_pos(Int16 cardno, Int16 axis,Int32   pos);
/*set values for the actual position counter
cardno	Card number
axis	Axis number
value	Range (-2147483648~+2147483647)
Return	0: Correct				1: Wrong
*/


//----------------------------------------------------//
//               CATEGORY OF MOTION PARAMETER CHECK                     //
//----------------------------------------------------//
       [DllImport("8940a1.dll")]
public static extern Int16  get_command_pos(Int16 cardno,Int16 axis,out Int32  pos);
/*Get logical position of each axis
cardno	Card number
axis	Axis number
pos		Indicator of logical position value
Return  0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  get_actual_pos(Int16 cardno,Int16 axis,out Int32  pos);
/*Get actual position of each axis (i.e., encoder feedback input)
cardno	Card number
axis	Axis number
pos		Indicator of actual position value
Return  0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  get_speed(Int16 cardno,Int16 axis,out Int32  speed);
/*Get current speed
cardno	Card number
axis	Axis number
speed	Indicator of current drive speed
Return	0: Correct				1: Wrong

*/
       [DllImport("8940a1.dll")]
public static extern Int16  get_out(Int16 cardno, Int16 number);
/*Get current Output status
cardno	Card number
axis	Axis number
Return	current Output status			-1: Wrong

*/

//----------------------------------------------------//
//                   driver function                       //
//----------------------------------------------------//
       [DllImport("8940a1.dll")]
public static extern Int16  pmove(Int16 cardno,Int16 axis,Int32   pos);
/*Single-axis quantitative drive
cardno 	Card number
axis	Axis number
pulse 	Outputted pulses
>0: move along positive direction
<0: move along negative direction
Range (-268435455~+268435455)
Return	0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  dec_stop(Int16 cardno,Int16 axis);
/* Deceleration stop
cradno	Card number
axis	Axis number
Return	0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  sudden_stop(Int16 cardno,Int16 axis);
/*Sudden stop
cardno Card number
axis   Axis number
Return 0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  inp_move2(Int16 cardno,Int16 axis1,Int16 axis2,Int32   pulse1,Int32   pulse2);
/* 2-axis interpolation
cardno	        Card number
axis1,axis2     Axis number joining interpolation
pulse1,pulse2	Relative distance of movemen 
Range (-8388608~+8388607)
Return	0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  inp_move3(Int16 cardno,Int16 axis1,Int16 axis2,Int16 axis3,Int32   pulse1,Int32   pulse2,Int32   pulse3);
/*3-axis interpolation
cardno	        Card number
axis1,axis2,axis3  Axis number joining interpolation
pulse1,pulse2,pulse3	Relative distance of movemen 
Range (-8388608~+8388607)
Return	0: Correct				1: Wrong
*/
       [DllImport("8940a1.dll")]
public static extern Int16  inp_move4(Int16 cardno,Int32   pulse1,Int32   pulse2,Int32   pulse3,Int32   pulse4);
/*4-axis interpolation
cardno Card number		
pulse1,pulse2,pulse3,pulse4  Relative distance of movement along X-Y-Z-W axis
Range (-8388608~+8388607)
Return	0: Correct				1: Wrong
*/

//-------------------------------------------------//
//               CATEGORY OF SWITCH AMOUNT INPUT/ OUTPUT                  //
//-------------------------------------------------//
       [DllImport("8940a1.dll")]
public static extern Int16  read_bit(Int16 cardno,Int16 number);
/*Read single input point
cardno	Card number
number	Input point (0-39)
Return
0: low level
1: high level
-1: error
*/
       [DllImport("8940a1.dll")]
public static extern Int16  write_bit(Int16 cardno,Int16 number,Int16 value);
/*Output single output point
cardno	Card number
number	Output point (0-15)
value	0: low		1: high		
Return  0: correct  1: wrong
*/
       [DllImport("8940a1.dll")]

public static extern Int16  set_suddenstop_mode(Int16 cardno,Int16 v,Int16 logic);
/*Hardware stop
cardno	Card number
v       0: Apply;               1: Don't apply
logical 0: low level;           1: high level
Return	0: Correct				1: Wrong
Remark: Hardware stop signals are assigned to use the 34 pin at the P3 terminal panel (IN31)
*/
       [DllImport("8940a1.dll")]
public static extern Int16  get_delay_status(Int16 cardno);
/*Get delay status
cardno	Card number
Return  0: delay stop          1: delay in process
*/
       [DllImport("8940a1.dll")]
public static extern Int16  set_delay_time(Int16 cardno,Int32   time);
/*set delay time
cardno	Card number
time    Delay time
Return	0: Correct				1: Wrong
Remark: The time unit is 1/8us, with the maximum integer value as its maximum value
*/

//*********************************************//
//               Composite drives              //
//*********************************************//
       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_relative_move(Int16 cardno, Int16 axis, Int32   pulse, Int32   lspd ,Int32   hspd, double tacc);
/************ Symmetrical relative movement of single-axis ***************
function: Refer to the current position and perform quantitative movement in the symmetrical
acceleration/deceleration
para:
     cardno-card number
	 axis---axis number
	 pulse-- Pulse
	 lspd--- Low speed
	 hspd--- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
*******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_absolute_move(Int16 cardno, Int16 axis, Int32   pulse, Int32   lspd ,Int32   hspd, double tacc)  ;
/************** Symmetrical absolute movement of single-axis ***********
function: Refer to the position of zero point and perform quantitative movement in the symmetrical
acceleration/deceleration
para:
     cardno -card number
	 axis ---axis number
	 pulse -- Pulse
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0: correct 1: wrong
*******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_relative_line2(Int16 cardno, Int16 axis1, Int16 axis2, Int32   pulse1, Int32   pulse2, Int32   lspd ,Int32   hspd, double tacc)  ;
/***** Relative movement of two-axis symmetrical linear interpolation ********
function: Refer to current position and perform linear interpolation in symmetrical
acceleration/deceleration
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 pulse1-- pulse 1
	 pulse2-- pulse 2
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_absolute_line2(Int16 cardno, Int16 axis1, Int16 axis2, Int32   pulse1, Int32   pulse2, Int32   lspd ,Int32   hspd, double tacc);
/****** Two axes symmetric linear interpolation absolute moving ********
function: Refer to the position of zero point and perform linear interpolation in symmetrical
acceleration/deceleration
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 pulse1—pulse of axis 1
	 pulse2-- pulse of axis 2
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_relative_line3(Int16 cardno, Int16 axis1, Int16 axis2, Int16 axis3, Int32   pulse1, Int32   pulse2, Int32   pulse3, Int32   lspd ,Int32   hspd, double tacc)  ;
/***** Three axes symmetric linear interpolation relative moving ******
function: Refer to current position and perform linear interpolation in symmetric
acceleration/deceleration
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 axis3---axis number3
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_absolute_line3(Int16 cardno, Int16 axis1, Int16 axis2, Int16 axis3, Int32   pulse1, Int32   pulse2, Int32   pulse3, Int32   lspd ,Int32   hspd, double tacc)  ;
/******Three axes symmetric linear interpolation absolute moving **********
function: Refer to the position of zero point and perform linear interpolation in symmetric
acceleration/deceleration.
para:
     cardno-card number
	 axis1---axis number1
	 axis2---axis number2
	 axis3---axis number3
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16  symmetry_relative_line4(Int16 cardno,Int32   pulse1, Int32   pulse2, Int32   pulse3,  Int32   pulse4,Int32   lspd ,Int32   hspd, double tacc);
/***** Four axes symmetric linear interpolation relative moving ******
function: Refer to current position and perform linear interpolation in symmetric
acceleration/deceleration
para:
     cardno-card number
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 pulse4-- pulse of axis 4
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
******************************************************************/

       [DllImport("8940a1.dll")]

public static extern Int16  symmetry_absolute_line4(Int16 cardno, Int32   pulse1, Int32   pulse2, Int32   pulse3, Int32   pulse4,Int32   lspd ,Int32   hspd, double tacc);
/******Four axes symmetric linear interpolation absolute moving **********
function: Refer to the position of zero point and perform linear interpolation in symmetric
acceleration/deceleration.
para:
     cardno-card number
	 pulse1-- pulse of axis 1
	 pulse2-- pulse of axis 2
	 pulse3-- pulse of axis 3
	 pulse4-- pulse of axis 4
	 lspd --- Low speed
	 hspd --- High speed
	 tacc--- Time of acceleration (Unit: sec)
return value 0：correct 1：wrong
******************************************************************/


//*********************************************//
//               external signal drive                    //
//*********************************************//
       [DllImport("8940a1.dll")]
public static extern Int16 manual_pmove(Int16 cardno, Int16 axis, Int32   pos);
/* Quantitative drive function of external signal 
function: Quantitative drive function of external signal
para:
     cardno card number
	 axis axis number
	 pulse pulse
Return 0：Correct 1：Wrong
Note: (1) Send out quantitative pulse, but the drive does not start immediately until the external
	  signal level changes
	  (2)Ordinary button and handwheel are acceptable.
*/
       [DllImport("8940a1.dll")]
public static extern Int16 manual_continue(Int16 cardno, Int16 axis);
/*Continuous drive function of external signal 
function: Continuous drive function of external signal
para:
     cardno card number
	 axis axis number
Return 0：Correct 1：Wrong
Note: (1) Send out fixed pulse, but the drive does not start immediately until the level of external
signal changes
(2) Ordinary button and handwheel are acceptable.
*/
       [DllImport("8940a1.dll")]
public static extern Int16 manual_disable(Int16 cardno, Int16 axis);
/* Shut down the enabling of external signal drive 
function: Shut down the enabling of external signal drive
para:
     cardno card number
     axis axis number
Return 0：Correct 1：Wrong
*/

//*********************************************//
//               lock  position                    //
//*********************************************//
       [DllImport("8940a1.dll")]
public static extern Int16 set_lock_position(Int16 cardno, Int16 axis,Int16 mode,Int16 regi,Int16 logical);
/*set lock mode
function:lock the logical position and real position for all axes
para: 
     cardno —card number
     axis   —reference axis
	 mode   —set lock mode   0:inefficacy         1:efficiency
     regi   —register mode   0:logical position   1:real position
     logical—level signal    0: from high to low  1:from low to high
retutrn 0：correct 1：wrong
Note: Use IN signal of specific axis as the trigger signal
*/
       [DllImport("8940a1.dll")]
public static extern Int16 get_lock_status(Int16 cardno, Int16 axis, out Int16  v);
/*Function: Get the status of position lock
Parameter:
cardno      card number
axis         axis number(1-4)
status       Lock status (0: unlocked, 1: locked)
Return value         0:correct          1:wrong
****************************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 get_lock_position(Int16 cardno,Int16 axis,out Int32  pos);
/**********************get lock position************************
Function: Get the locked position
para:
     cardno    card number
     axis      axis number
     pos       lock position
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 clr_lock_status(Int16 cardno, Int16 axis);
/**********************clean lock position************************
Function: Clean the locked position
para:
     cardno    card number
     axis      axis number
Return 0：Correct 1：Wrong
******************************************************************/



//*********************************************//
//                FIFO buffer                    //
//*********************************************//
       [DllImport("8940a1.dll")]
public static extern Int16 fifo_inp_move1(Int16 cardno,Int16 axis1,Int32   pulse1,Int32   speed);
/**************************single axis FIFO**************************
Function:single axis FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	speed       FIFO speed 
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 fifo_inp_move2(Int16 cardno,Int16 axis1,Int16 axis2,Int32   pulse1,Int32   pulse2,Int32   speed);
/**************************two axes FIFO**************************
Function:two axes FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	axis2	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	pulse2      pulses in FIFO buffer
	speed       FIFO speed 
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 fifo_inp_move3(Int16 cardno,Int16 axis1,Int16 axis2,Int16 axis3,Int32   pulse1,Int32   pulse2,Int32   pulse3,Int32   speed);
/**************************three axes FIFO**************************
Function:three axes FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	axis2	    axis number(1-4)
    axis3	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	pulse2      pulses in FIFO buffer
	pulse3      pulses in FIFO buffer
	speed       FIFO speed 
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 fifo_inp_move4(Int16 cardno,Int32   pulse1,Int32   pulse2,Int32   pulse3,Int32   pulse4,Int32   speed);
/**************************three axes FIFO**************************
Function:four axes FIFO
para:
	cardno      card number
	axis1	    axis number(1-4)
	axis2	    axis number(1-4)
    axis3	    axis number(1-4)
	axis4	    axis number(1-4)
	pulse1      pulses in FIFO buffer
	pulse2      pulses in FIFO buffer
	pulse3      pulses in FIFO buffer
	pulse4      pulses in FIFO buffer
	speed       FIFO speed 
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 reset_fifo(Int16 cardno);
/**************************reset fifo cache**************************
Function:reset fifo buffer
para:
	cardno      card number
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 read_fifo_count(Int16 cardno,out Int16  value);
/**************************read fifo **********************
Function:read fifo cache,count the fifo command haven't been implemented 
para:
	cardno      card number
	value       the space(bytes) of commands that haven't been implemented     
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 read_fifo_empty(Int16 cardno);
/**************************read fifo **********************
Function:read the fifo buffer, count fifo whether it is a empty buffer
para:
	cardno      card number
Return 0：Correct 1：Wrong
******************************************************************/

       [DllImport("8940a1.dll")]
public static extern Int16 read_fifo_full(Int16 cardno);
/**************************read fifo **********************
Function:read the fifo buffer, estimate for that whether the buffer is full
para:
	cardno      card number
Return 0：Correct 1：Wrong
******************************************************************/

      [DllImport("8940a1.dll")]
public static extern Int16 continue_move(Int16 cardno, Int16 axis, Int16 dir);
/************************* Function: Single continuous movement ****************** ********
Function: Single continuous movement
Parameters:
cardno Card
axis axis number (1-4)
dir 0: positive; 1: Negative

Returns: -1: STOP signal from the limit or stop; 1: error; 0: correct.
Note: Write-driven command, be sure to correctly set the speed parameters.
************************************************** ******************/

      [DllImport ("8940a1.dll")]
 public static extern Int16 home1 (Int16 cardno, Int16 axis, Int16 backDir, Int16 logical0, Int16 logical1, Int32 homeStartV, Int32 homeSpeed,
 Int32 homeAcc, Int32 searchRange, Int32 searchSpeed, Int32 phaseSpeed, Int32 pulseUnit);
 /************************** Axis back to the origin ******************* ***
 Function: Perform single-axis movement back to the origin
 Parameters:
 cardno Card
 axis axis number (1-4)
 backDir direction back to the origin 0: positive 1: negative
 logical0 back to the origin stop0 set 0: active low 1: active high
 logical1 back to the origin stop1 set 0: active low 1: active high 1: invalid (does not search for Z-phase)
 homeStartV back to the origin initiation speed, range :0-2M
 homeSpeed ​​back to the origin of drive speed, range :0-2M
 homeAcc back to the origin of acceleration in the range 0 -64 000
 searchRange origin range (not too large)
 searchSpeed ​​stop0 search speed (not too high)
 phaseSpeed ​​Z-phase search speed (not too high)
 pulseUnit pulses per revolution

 Return value 0: Homing success; -1: Parameter error; -2: fail back to the origin, (the origin met the range limit or too small); 1: back to the origin is suspended
 Description:
  (1) is divided into four big step back to the origin:
 The first step: fast approaching stop0 (logical0 origin set), find stop0;
 Step Two: Slow reverse left stop0, reverse pulses moving range specifying the origin;
 The third step: slow again close stop0;
 Step four: slow close stop1 (logical1 Encoder Z-phase).
  (2) can choose whether to perform the fourth step, by logical1 to choose.
  (3) For multi-axis back to the origin, must wait for the return to the origin after the end of a shaft, the shaft back to the origin of the next action.

 ************************************************** ****************/


   }
}
